/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.client.gui.handler;

import de.cristelknight.doapi.client.recipebook.IRecipeBookGroup;
import de.cristelknight.doapi.client.recipebook.handler.AbstractRecipeBookGUIScreenHandler;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.satisfy.candlelight.client.gui.handler.slot.ExtendedSlot;
import net.satisfy.candlelight.client.recipebook.custom.CookingPotRecipeBookGroup;
import net.satisfy.candlelight.recipe.CookingPotRecipe;
import net.satisfy.candlelight.registry.ScreenHandlerTypeRegistry;

public class CookingPotGuiHandler
extends AbstractRecipeBookGUIScreenHandler {
    private final ContainerData propertyDelegate;

    public CookingPotGuiHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(8), (ContainerData)new SimpleContainerData(2));
    }

    public CookingPotGuiHandler(int syncId, Inventory playerInventory, Container inventory, ContainerData propertyDelegate) {
        super((MenuType)ScreenHandlerTypeRegistry.COOKING_POT_SCREEN_HANDLER.get(), syncId, 7, playerInventory, inventory, propertyDelegate);
        this.buildBlockEntityContainer(inventory);
        this.buildPlayerContainer(playerInventory);
        this.propertyDelegate = propertyDelegate;
        this.m_38884_(propertyDelegate);
    }

    private void buildBlockEntityContainer(Container inventory) {
        this.m_38897_(new ExtendedSlot(inventory, 6, 95, 55, stack -> stack.m_150930_(Items.f_42399_)));
        for (int row = 0; row < 2; ++row) {
            for (int slot = 0; slot < 3; ++slot) {
                this.m_38897_(new Slot(inventory, slot + row + row * 2, 30 + slot * 18, 17 + row * 18));
            }
        }
        this.m_38897_(new Slot(inventory, 7, 124, 28){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
    }

    private void buildPlayerContainer(Inventory playerInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public boolean isBeingBurned() {
        return this.propertyDelegate.m_6413_(1) != 0;
    }

    public int getScaledProgress(int arrowWidth) {
        int progress = this.propertyDelegate.m_6413_(0);
        int totalProgress = 600;
        if (progress == 0) {
            return 0;
        }
        return progress * arrowWidth / 600 + 1;
    }

    public List<IRecipeBookGroup> getGroups() {
        return CookingPotRecipeBookGroup.POT_GROUPS;
    }

    public boolean hasIngredient(Recipe<?> recipe) {
        if (recipe instanceof CookingPotRecipe) {
            CookingPotRecipe cookingPotRecipe = (CookingPotRecipe)recipe;
            for (Ingredient ingredient : cookingPotRecipe.m_7527_()) {
                boolean found = false;
                for (Slot slot : this.f_38839_) {
                    if (!ingredient.test(slot.m_7993_())) continue;
                    found = true;
                }
                if (found) continue;
                return false;
            }
            ItemStack container = cookingPotRecipe.getContainer();
            for (Slot slot : this.f_38839_) {
                if (container.m_41720_() != slot.m_7993_().m_41720_()) continue;
                return true;
            }
        }
        return false;
    }

    public int getCraftingSlotCount() {
        return 7;
    }
}

